﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.Utilities;
using System.Net;
using System.IO;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for HeldTransactions.xaml
    /// </summary>
    public partial class SyncToLiveDatabase : Page
    {
        public static int currentSelection = -1;

        public SyncToLiveDatabase()
        {
            InitializeComponent();
        }

        private void LoadOrders()
        {
            List<Orders> pcList = OrdersBL.GetOfflineList(Guid.Empty, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (pcList != null && pcList.Count > 0)
            {
                pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
            }
            dgridOrders.Dispatcher.BeginInvoke(new Action(() => dgridOrders.ItemsSource = pcList));

        }

        private void LoadCustomers()
        {

            List<UserAccount> myCust = UserAccountBL.GetOfflineList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue)
                                                    .Where(u => u.UserRoleType.Trim().ToLower() == "user").ToList<UserAccount>(); ;
            dgridCustomers.Dispatcher.BeginInvoke(new Action(() => dgridCustomers.ItemsSource = myCust));

        }

        private void dgridHeldTransactions_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            if (sender != null)
            {
                if (dgridOrders != null && dgridOrders.SelectedItems != null && dgridOrders.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = dgridOrders.ItemContainerGenerator.ContainerFromItem(dgridOrders.SelectedItem) as DataGridRow;
                    AppSession.CurrentOrders = dgr.DataContext as Orders;
                    AppSession.CurrentUser = (AppSession.CurrentOrders.UsersAccountID != null && AppSession.CurrentOrders.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(AppSession.CurrentOrders.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
                    RemoveHeldTransaction(AppSession.CurrentOrders.UniqueID);
                    AppSession.CurrentOrders.UniqueID = Guid.Empty;
                    MasterWindow Master = new MasterWindow();
                    Master.LoadPages(new Ordering(), Menus.ORDER);
                }
            }
        }

        private void btnSelectTransaction_Click(object sender, RoutedEventArgs e)
        {
            Button btnSelectTransaction = sender as Button;
            Guid holdTransactionID = Guid.Parse(btnSelectTransaction.Tag.ToString());
            Orders curOrder = AppSession.HeldTransactions.Where(o => o.UniqueID == holdTransactionID).FirstOrDefault();
            if (curOrder != null)
            {
                AppSession.CurrentOrders = curOrder;
                AppSession.CurrentUser = (curOrder.UsersAccountID != null && curOrder.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(curOrder.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
                RemoveHeldTransaction(AppSession.CurrentOrders.UniqueID);
                AppSession.CurrentOrders.UniqueID = Guid.Empty;
                MasterWindow Master = new MasterWindow();
                Master.LoadPages(new Ordering(), Menus.ORDER);
            }
        }

        public void RemoveHeldTransaction(Guid uniqueID)
        {
            AppSession.HeldTransactions.Remove(AppSession.HeldTransactions.Where(o => o.UniqueID == uniqueID).FirstOrDefault());
        }

        private void btnOrders_Click(object sender, RoutedEventArgs e)
        {
            dgridOrders.Visibility = System.Windows.Visibility.Visible;
            dgridCustomers.Visibility = System.Windows.Visibility.Hidden;
            LoadOrders();
            currentSelection = 1;
        }

        private void btnCustomers_Click(object sender, RoutedEventArgs e)
        {
            dgridCustomers.Visibility = System.Windows.Visibility.Visible;
            dgridOrders.Visibility = System.Windows.Visibility.Hidden;
            LoadCustomers();
            currentSelection = 3;
        }

        private void UpdateItems()
        {
            AppSession.ProductsList = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).ToList<Products>();
            bool IsConnectedToInternet = GlobalConfigurations.AppConfiguration.IsConnectedToInternet();
            AppSession.ProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 = IsConnectedToInternet ?
                (string.IsNullOrEmpty(product.Image1) ? AppSession.ImagePath + AppSession.NoImagePath : AppSession.ImagePath + product.Image1)
                : (string.IsNullOrEmpty(product.Image1) ? AppSession.LocalImagePath + AppSession.NoImagePath : AppSession.LocalImagePath + product.Image1));
        }

        private void SyncImages()
        {
            if (GlobalConfigurations.AppConfiguration.IsConnectedToInternet())
            {
                List<Products> OnlineProductsList = ProductsBL.GetList(Guid.Empty, string.Empty).Where(a => a.IsActive).ToList<Products>();

                OnlineProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image2 = (string.IsNullOrEmpty(product.Image1) ? AppSession.LocalImagePath + AppSession.NoImagePath : AppSession.LocalImagePath + product.Image1));
                OnlineProductsList.OrderBy(product => product.SequenceNo).ToList().ForEach(product => product.Image1 = (string.IsNullOrEmpty(product.Image1) ? AppSession.ImagePath + AppSession.NoImagePath : AppSession.ImagePath + product.Image1));


                foreach (Products url in OnlineProductsList)
                {
                    Uri urlUri = new Uri(url.Image1);
                    var request = WebRequest.CreateDefault(urlUri);

                    byte[] buffer = new byte[4096];

                    using (var target = new FileStream(url.Image2, FileMode.OpenOrCreate, FileAccess.Write))
                    {
                        using (var response = request.GetResponse())
                        {
                            using (var stream = response.GetResponseStream())
                            {
                                int read;

                                while ((read = stream.Read(buffer, 0, buffer.Length)) > 0)
                                {
                                    target.Write(buffer, 0, read);
                                }
                            }
                        }
                    }
                }
            }
        }

        private void btnSync_Click(object sender, RoutedEventArgs e)
        {
            if (GlobalConfigurations.AppConfiguration.IsConnectedToInternet())
            {
                ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                  {
                      switch (currentSelection)
                      {
                          case 1:
                              List<Orders> myOrders = OrdersBL.GetOfflineList(Guid.Empty, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                              if (myOrders != null && myOrders.Count > 0)
                              {
                                  myOrders = myOrders.Where(a => a.IsActive).ToList<Orders>();
                              }

                              foreach (Orders currentOrder in myOrders)
                              {
                                  OrdersBL.Save(currentOrder);
                                  OrdersBL.GenerateInvoice(AppSession.CurrentOrders.UniqueID);
                                  AppSession.UpdateOrderProductQty(currentOrder);
                              }
                              OrdersBL.Delete();
                              ProductsBL.Delete();
                              List<Products> AllProducts = ProductsBL.GetList(Guid.Empty, string.Empty);
                              foreach (Products Product in AllProducts)
                              {
                                  ProductsBL.SaveLocal(Product);
                              }
                              UpdateItems();
                              SyncImages();
                              currentSelection = -1;
                              LoadOrders();
                              App.ShowMessageBox(myOrders.Count.ToString() + " Orders has been synced to online.", "Sync Complete");
                              break;

                          case 3:
                              List<UserAccount> myCust = UserAccountBL.GetOfflineList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue)
                                                                      .Where(u => u.UserRoleType.Trim().ToLower() == "user" && u.IsActive).ToList<UserAccount>();

                              foreach (UserAccount currentCust in myCust)
                              {
                                  UserAccountBL.Save(currentCust);
                              }

                              UserAccountBL.DeleteLocal();
                              currentSelection = -1;
                              LoadCustomers();
                              App.ShowMessageBox(myCust.Count.ToString() + " Customers has been synced to online.", "Sync Complete");
                              break;

                          default:
                              currentSelection = -1;
                              App.ShowMessageBox("Please select any option to sync.", "Syncing");
                              break;
                      }
                  });
            }
            else
            {
                App.ShowMessageBox("Internet Connection is not available. Please connect to the internet", "Syncing");
            }
        }
    }
}
